//
//	VSay.H
//
//		Created	by	Myeong-Wuk
//				at	1995. 10. 6.
//		
//		Modified by Hang-Seop Lee
//				at 1996.6
//
//	This module playes the voice for korean text by voice synthesis.
//
//	Copyright (C) 1995 ETRI.
//	All right reserved.
//
//	Including Functions :
//		- VSayInit
//		- VSayStr
//		- VSayUninit
//		- SpeechSynthInit
//		- SpeechSynthString


/* ========== Functions Declaration ========== */

/* ---------- VSayInit ---------- */
//
//	VSayInit()
//
//	The VSayInit function initializes some environment variables
//		and calles some initialization functions.
//

int MPEG4_Init();

/* ---------- VSayStr ---------- */
//
//	VSayStr(in char* string)
//		- string : a input korean text string
//
//	The VSayStr function sayes the given string
//

void VSayStr(char*);
void VSayFile(char*);


/* ---------- VSayUninit ---------- */
//
//	VSayUninit()
//
//	The VSayUninit function uninitializes some variables
//		and calles some uninitialization functions.
//

void VSayUninit();

//------- PSOLA2 Synthersizer Function -------//

extern void SpeechSynthInit();
extern void SpeechSynthString( char str[] );

//------- Sound I/O  function --------//
extern BOOL SoundOutPause();
extern BOOL SoundOutRestart();
extern BOOL SoundOutStop();
extern int SoundPlay(unsigned char *buf, int n_buf);
extern BOOL SoundOutInit();
extern BOOL SoundOutUninit();

void MPEG4_TTS_Play();

